Spesifikasi Final Aplikasi Statis "Enchanted Love Portal"
Tujuan: Mewujudkan pengalaman romantic & sweetness celebration khusus untuk GG dalam bentuk situs statis yang ringan, mudah dipelihara, dan bisa langsung di-deploy tanpa backend.

Visi & Ruang Lingkup
- Situs statis berbasis HTML/CSS/JS, tanpa Laravel routes, tanpa database.
- Semua konten (quotes, gallery, map points, achievements, reminders, journal) didefinisikan dalam berkas data JavaScript di folder `public/gg/data`.
- Penambahan foto dilakukan dengan menaruh file di `public/gg/images`, lalu mereferensikannya di `public/gg/data/gallery.js`.

Halaman MVP
- Home: greeting untuk GG, random quotes, lovemeter sederhana (counter statis), tautan ke halaman lain.
- Gallery: grid bergaya Pinterest dengan efek hover 3D; sumber data dari `data/gallery.js`.

Halaman Lanjutan (opsional, bertahap)
- Love Map: peta pixel-art statis; titik lokasi di `data/map.js`.
- Journal: daftar entri statis dari `data/journal.js`.
- Achievements: lencana dan hadiah virtual dari `data/achievements.js`.
- Reminders: daftar tanggal penting dari `data/reminders.js`.

Arsitektur Statis & Struktur Folder
- `public/gg/index.html` — Halaman beranda.
- `public/gg/gallery.html` — Halaman galeri kenangan.
- `public/gg/css/styles.css` — Gaya global dan tema.
- `public/gg/js/app.js` — Script util dan inisialisasi halaman.
- `public/gg/data/quotes.js` — Array quotes untuk home.
- `public/gg/data/gallery.js` — Daftar foto (path, judul, caption, tags).
- `public/gg/images/` — Tempat menyimpan semua gambar.

Skema Data
- Quotes (`quotes.js`): `window.QUOTES = ["..."]`.
- Gallery (`gallery.js`): `window.GALLERY = [{ file: "images/xxx.jpg", title: "...", caption: "...", tags: ["..."] }]`.
- Map (`map.js`, opsional): `window.MAP_POINTS = [{ name: "...", lat: ..., lng: ..., note: "..." }]`.
- Journal (`journal.js`, opsional): `window.JOURNAL = [{ date: "YYYY-MM-DD", mood: "...", text: "..." }]`.
- Achievements (`achievements.js`, opsional): `window.ACHIEVEMENTS = [{ title: "...", earnedAt: "YYYY-MM-DD" }]`.
- Reminders (`reminders.js`, opsional): `window.REMINDERS = [{ date: "YYYY-MM-DD", title: "..." }]`.

Desain & Tema
- Warna: pastel pink, soft purple, dreamy blue, warm yellow.
- Tipografi: Poppins (Google Fonts) dengan gaya lembut.
- Motion: animasi kecil (hover, fade-in, float) yang smooth dan playful.
- Ikon: bisa gunakan SVG sederhana atau library ringan bila diperlukan.

Interaksi & Animasi
- Floating hearts: animasi CSS sederhana (keyframes) pada dekorasi di header.
- Fade-in cards: setiap card di galeri muncul bertahap.
- Hover tilt: transform 3D ringan pada kartu.

Aksesibilitas
- Pastikan `alt` untuk semua gambar di gallery.
- Kontras warna cukup; font-size minimum 14px.
- Navigasi keyboard dasar (fokus pada tautan dan kartu).

Performa
- Gunakan gambar terkompresi (WebP/JPEG quality 70–80).
- Lazy-load gambar di galeri.
- Cache statis dari server/hosting.

Cara Menambah Konten (Foto)
- Taruh file gambar di `public/gg/images`.
- Tambahkan entri pada `public/gg/data/gallery.js` dengan struktur:

```
window.GALLERY = [
  { file: "images/gg-anniversary.jpg", title: "Anniversary", caption: "Momen manis bersama GG", tags: ["sweet", "anniversary"] },
  // ... foto-foto lainnya
];
```

Rencana Pengembangan Bertahap
- Tahap 1 (MVP): Home + Gallery + Lovemeter statis.
- Tahap 2: Tambah Love Map & Achievements.
- Tahap 3: Journal & Reminders.

Testing Manual
- Buka `index.html` dan `gallery.html` secara lokal/di server, cek tampilan.
- Pastikan semua tautan berfungsi dan gambar yang ditambahkan muncul sesuai.

