function getRandomQuote() {
  const quotes = (window.QUOTES && Array.isArray(window.QUOTES)) ? window.QUOTES : [];
  if (!quotes.length) return "Halo GG! Semua hari terasa manis bersamamu ✨";
  return quotes[Math.floor(Math.random() * quotes.length)];
}

function fadeInSequence(selector) {
  const reduce = window.matchMedia && window.matchMedia('(prefers-reduced-motion: reduce)').matches;
  const items = document.querySelectorAll(selector);
  items.forEach((el, index) => {
    if (reduce) {
      el.style.opacity = 1;
      el.style.transform = 'translateY(0)';
      return;
    }
    setTimeout(() => {
      el.style.opacity = 1;
      el.style.transform = 'translateY(0)';
    }, 100 * index);
  });
}

function initHome() {
  const quoteEl = document.getElementById('random-quote');
  if (quoteEl) quoteEl.textContent = getRandomQuote();
  fadeInSequence('.cute-card');
}

function createTag(tag) {
  const span = document.createElement('span');
  span.className = 'tag';
  span.textContent = tag;
  return span;
}

function createCard(item) {
  const card = document.createElement('div');
  card.className = 'card';

  const img = document.createElement('img');
  img.src = item.file;
  img.alt = item.title || 'Cute Memory';
  img.loading = 'lazy';
  img.decoding = 'async';

  const info = document.createElement('div');
  info.className = 'info';

  const title = document.createElement('h4');
  title.className = 'title';
  title.textContent = item.title || 'Untitled';

  const caption = document.createElement('p');
  caption.className = 'caption';
  caption.textContent = item.caption || '';

  const tags = document.createElement('div');
  tags.className = 'tags';
  (item.tags || []).forEach(t => tags.appendChild(createTag(t)));

  info.appendChild(title);
  info.appendChild(caption);
  info.appendChild(tags);

  card.appendChild(img);
  card.appendChild(info);
  return card;
}

function initGallery() {
  const grid = document.getElementById('gallery-grid');
  const empty = document.getElementById('empty-gallery');
  const data = (window.GALLERY && Array.isArray(window.GALLERY)) ? window.GALLERY : [];

  if (!grid) return;
  if (!data.length) {
    if (empty) empty.classList.remove('hidden');
    return;
  }

  data.forEach(item => grid.appendChild(createCard(item)));
  fadeInSequence('.card');
}

function initRoad() {
  const data = (window.GALLERY && Array.isArray(window.GALLERY)) ? window.GALLERY : [];
  const photo = document.getElementById('road-photo');
  const caption = document.getElementById('road-caption');
  const progressText = document.getElementById('road-progress');
  const progressBar = document.getElementById('progress-bar');
  const btnPrev = document.getElementById('btnPrev');
  const btnNext = document.getElementById('btnNext');
  const themeSelect = document.getElementById('theme-select');
  const stage = document.getElementById('road-stage');
  const decorLayer = document.getElementById('decor-layer');
  const container = document.querySelector('.road-container');
  const reduce = window.matchMedia && window.matchMedia('(prefers-reduced-motion: reduce)').matches;
  let index = 0;
  // rotasi mini-game
  const gameSections = {
    validate: document.getElementById('game-validate'),
    catch: document.getElementById('game-catch'),
    compliment: document.getElementById('game-compliment')
  };
  const gameOrder = ['validate','catch','compliment'];
  let gameIndex = 0;

  if (!photo || !caption || !data.length) return;

  let currentTheme = 'pastel-love';
  function setTheme(name) {
    if (!container || !stage) return;
    container.classList.remove('theme-pastel-love','theme-starry','theme-polaroid');
    stage.classList.remove('polaroid');
    if (name === 'pastel-love') container.classList.add('theme-pastel-love');
    if (name === 'starry') container.classList.add('theme-starry');
    if (name === 'polaroid') { container.classList.add('theme-polaroid'); stage.classList.add('polaroid'); }
    currentTheme = name;
    refreshDecor();
  }

  function refreshDecor() {
    if (!decorLayer) return;
    decorLayer.innerHTML = '';
    if (reduce) return;
    const rand = (min, max) => Math.random() * (max - min) + min;
    const pick = (arr) => arr[Math.floor(Math.random() * arr.length)];
    const themeSets = {
      'pastel-love': { icons: ['💖','💕','🫧','🌸','✨'], types: ['sparkle','bubble','petal','sparkle'] },
      'starry': { icons: ['✨','🌟','💫','🪐'], types: ['sparkle','sparkle','sparkle','sparkle'] },
      'polaroid': { icons: ['🎀','🌸','💌','✨'], types: ['sticker','petal','sticker','sparkle'] }
    };
    const set = themeSets[currentTheme] || themeSets['pastel-love'];
    const count = 14;
    for (let i = 0; i < count; i++) {
      const span = document.createElement('span');
      const type = pick(set.types);
      span.className = type;
      span.textContent = pick(set.icons);
      span.setAttribute('aria-hidden','true');
      const left = rand(2, 98);
      const top = rand(4, 92);
      span.style.left = left + '%';
      span.style.top = top + '%';
      // variasi animasi
      const dur = rand(2, 7).toFixed(2) + 's';
      span.style.animationDuration = dur;
      span.style.animationDelay = (-rand(0, 3)).toFixed(2) + 's';
      decorLayer.appendChild(span);
    }
  }

  function render() {
    const item = data[index];
    photo.src = item.file;
    photo.alt = item.title || 'Cute Moment';
    photo.loading = 'lazy';
    photo.decoding = 'async';
    caption.textContent = (item.title || 'Untitled') + (item.caption ? ' — ' + item.caption : '');
    if (progressText) progressText.textContent = (index + 1) + ' / ' + data.length;
    if (progressBar) progressBar.style.width = Math.round(((index + 1) / data.length) * 100) + '%';
    if (!reduce) {
      photo.style.opacity = 0;
      setTimeout(() => { photo.style.opacity = 1; }, 80);
    } else {
      photo.style.opacity = 1;
    }
    // sesuaikan area dekorasi agar tidak menutupi caption
    if (decorLayer && caption) {
      const bottom = Math.max(40, caption.offsetHeight + 12);
      decorLayer.style.inset = `.5rem .5rem ${bottom}px .5rem`;
    }
    refreshDecor();
  }

  function next() { index = (index + 1) % data.length; render(); rotateGameNext(); }
  function prev() { index = (index - 1 + data.length) % data.length; render(); rotateGamePrev(); }

  if (btnPrev) btnPrev.addEventListener('click', () => { prev(); });
  if (btnNext) btnNext.addEventListener('click', () => { next(); });

  const themes = ['pastel-love','starry','polaroid'];
  const initialTheme = themes[Math.floor(Math.random() * themes.length)];
  setTheme(initialTheme);
  if (themeSelect) {
    themeSelect.value = initialTheme;
    themeSelect.addEventListener('change', (e) => setTheme(e.target.value));
  }

  function showHearts() {
    if (reduce) return;
    const n = 12;
    for (let i = 0; i < n; i++) {
      const span = document.createElement('span');
      span.className = 'confetti-heart';
      span.textContent = '💖';
      span.style.left = Math.round(Math.random() * 90) + '%';
      span.style.bottom = '0';
      stage.appendChild(span);
      setTimeout(() => { if (span.parentNode) span.parentNode.removeChild(span); }, 2200);
    }
  }

  function celebrateFull() {
    // Efek meriah layar penuh (menghormati reduced-motion)
    if (reduce) { showHearts(); return; }
    const overlay = document.createElement('div');
    overlay.className = 'celebration-overlay';
    overlay.setAttribute('aria-hidden','true');
    const emojis = ['✨','💖','💕','💫','🌟','🎉','🎊','🌸'];
    const total = 84;
    for (let i = 0; i < total; i++) {
      const s = document.createElement('span');
      s.className = 'celebration-piece';
      s.textContent = emojis[Math.floor(Math.random() * emojis.length)];
      const left = Math.random() * 100; // vw
      const delay = (Math.random() * -1.8).toFixed(2) + 's';
      const dur = (2.6 + Math.random() * 2.2).toFixed(2) + 's';
      s.style.left = left + 'vw';
      s.style.top = (-10 + Math.random() * 10) + 'vh';
      s.style.setProperty('--dur', dur);
      s.style.animationDelay = delay;
      overlay.appendChild(s);
    }
    // bursts
    for (let i = 0; i < 6; i++) {
      const b = document.createElement('div');
      b.className = 'celebration-burst';
      b.style.left = (10 + Math.random() * 80) + 'vw';
      b.style.top = (20 + Math.random() * 50) + 'vh';
      b.style.animationDelay = (Math.random() * 0.6).toFixed(2) + 's';
      overlay.appendChild(b);
    }
    document.body.appendChild(overlay);
    setTimeout(() => { overlay.remove(); }, 3200);
  }

  const btnYes = document.getElementById('btnYes');
  const btnNo = document.getElementById('btnNo');
  const box = document.getElementById('no-game');
  const mgToggle = document.getElementById('minigames-enable');
  let minigamesEnabled = true;
  if (mgToggle) {
    minigamesEnabled = mgToggle.checked;
    mgToggle.addEventListener('change', (e) => {
      minigamesEnabled = !!e.target.checked;
    });
  }

  function moveNo() {
    if (!minigamesEnabled) return;
    if (!box || !btnNo) return;
    const rect = box.getBoundingClientRect();
    const maxX = rect.width - btnNo.offsetWidth;
    const maxY = rect.height - btnNo.offsetHeight;
    const x = Math.max(0, Math.min(maxX, Math.random() * maxX));
    const y = Math.max(0, Math.min(maxY, Math.random() * maxY));
    btnNo.style.left = x + 'px';
    btnNo.style.top = y + 'px';
  }

  if (btnNo) {
    btnNo.addEventListener('mouseenter', moveNo);
    btnNo.addEventListener('focus', moveNo);
    btnNo.addEventListener('click', (e) => { e.preventDefault(); moveNo(); if (btnYes) btnYes.focus(); });
  }
  if (btnYes) {
    btnYes.addEventListener('click', () => { celebrateFull(); showHearts(); next(); });
  }

  // Game 2 — Tangkap Hati
  const btnStartCatch = document.getElementById('btnStartCatch');
  const scoreText = document.getElementById('score-text');
  const catchArea = document.getElementById('catch-area');
  const catchStatus = document.getElementById('catch-status');
  let caught = 0;
  let catchTimer = null;
  let catchActive = false;

  function updateScore() {
    if (scoreText) scoreText.textContent = `${caught} / 5`;
  }

  function endCatchGame() {
    catchActive = false;
    if (catchTimer) { clearInterval(catchTimer); catchTimer = null; }
    if (catchArea) Array.from(catchArea.querySelectorAll('.heart-item')).forEach(el => el.remove());
  }

  // tampilkan satu mini-game saja pada satu waktu
  function showGame(key) {
    Object.keys(gameSections).forEach(k => {
      const el = gameSections[k];
      if (!el) return;
      if (k === key) el.classList.remove('hidden'); else el.classList.add('hidden');
    });
    // reset state saat berpindah game
    if (key === 'catch') {
      caught = 0;
      updateScore();
      endCatchGame();
      if (catchStatus) catchStatus.textContent = 'Tangkap 5 hati untuk buka bonus photo.';
    }
    if (key === 'compliment') {
      if (complimentInput) complimentInput.value = '';
      if (complimentError) complimentError.textContent = '';
    }
  }

  function rotateGameNext() {
    gameIndex = (gameIndex + 1) % gameOrder.length;
    showGame(gameOrder[gameIndex]);
  }
  function rotateGamePrev() {
    gameIndex = (gameIndex - 1 + gameOrder.length) % gameOrder.length;
    showGame(gameOrder[gameIndex]);
  }

  function onCatch() {
    if (!minigamesEnabled) return;
    caught++;
    updateScore();
    if (caught >= 5) {
      endCatchGame();
      if (catchStatus) catchStatus.textContent = 'Bonus photo terbuka!';
      showHearts();
      celebrateFull();
      const bonusIndex = (function(){
        for (let i = 0; i < data.length; i++) {
          const it = data[i];
          if (Array.isArray(it.tags) && it.tags.includes('bonus')) return i;
        }
        return Math.floor(Math.random() * data.length);
      })();
      index = bonusIndex;
      render();
    }
  }

  function spawnHeart() {
    if (!catchArea) return;
    const span = document.createElement('span');
    span.className = 'heart-item';
    span.textContent = '💖';
    span.setAttribute('role','button');
    span.setAttribute('tabindex','0');
    span.setAttribute('aria-label','Tangkap hati');
    const left = Math.round(Math.random() * (catchArea.clientWidth - 24));
    span.style.left = left + 'px';
    if (!reduce) {
      const dur = 2200 + Math.round(Math.random() * 1800);
      span.style.animationDuration = dur + 'ms';
      span.addEventListener('animationend', () => { if (span.parentNode) span.parentNode.removeChild(span); });
    } else {
      // Reduced motion: tempatkan secara acak di area
      const top = Math.round(Math.random() * (catchArea.clientHeight - 24));
      span.style.top = top + 'px';
    }
    span.addEventListener('click', () => { if (!catchActive) return; onCatch(); span.remove(); });
    span.addEventListener('keydown', (e) => {
      if (!catchActive) return;
      if (e.key === 'Enter' || e.key === ' ') { e.preventDefault(); onCatch(); span.remove(); }
    });
    catchArea.appendChild(span);
  }

  function startCatchGame() {
    if (!minigamesEnabled) return;
    if (!catchArea) return;
    caught = 0;
    updateScore();
    catchActive = true;
    if (catchStatus) catchStatus.textContent = 'Tangkap 5 hati untuk buka bonus photo.';
    const interval = reduce ? 1200 : 600;
    catchTimer = setInterval(() => { if (catchActive) spawnHeart(); }, interval);
  }

  if (btnStartCatch) btnStartCatch.addEventListener('click', startCatchGame);

  // Game 3 — Komplimen Manis
  const complimentInput = document.getElementById('compliment-input');
  const btnSubmitCompliment = document.getElementById('btnSubmitCompliment');
  const complimentError = document.getElementById('compliment-error');

  const negatives = ['tidak','enggak','gak','ga','benci','jelek','buruk','jahat'];
  function validateCompliment(text) {
    const t = (text || '').trim();
    if (t.length < 10) {
      if (complimentError) complimentError.textContent = 'Tulis minimal 10 huruf ya ✨';
      return false;
    }
    const lower = t.toLowerCase();
    if (negatives.some(n => lower.includes(n))) {
      if (complimentError) complimentError.textContent = 'Hindari kata negatif ya 💗';
      return false;
    }
    if (complimentError) complimentError.textContent = '';
    return true;
  }

  function submitCompliment() {
    if (!minigamesEnabled) return;
    if (!complimentInput) return;
    const text = complimentInput.value;
    if (!validateCompliment(text)) return;
    showHearts();
    celebrateFull();
    next();
  }

  if (btnSubmitCompliment) btnSubmitCompliment.addEventListener('click', submitCompliment);
  if (complimentInput) complimentInput.addEventListener('keydown', (e) => {
    if (e.key === 'Enter') { e.preventDefault(); submitCompliment(); }
  });

  // set game awal
  showGame(gameOrder[gameIndex]);

  render();
}